#ifndef PHYSIC_DATA_H
#define PHYSIC_DATA_H

#include "force.h"
#include "liste.h"

#define AUCUNE 4
#define HAUT 0
#define BAS 1
#define GAUCHE 2
#define DROITE 3
#define INDEFINIE 5

class PhysicData
{
    private:
        float m_fX;// coordonne X de l'entite
        float m_fY; // coordonne Y de l'entite
        float m_fFrot[4]; // coefficient de fortement du sol
        float m_fRebond[4]; // coefficient de rebond
        int m_iX1,m_iY1; // coordonnes relatives aux coordonnes du sprite du coin haut gauche du rectangle de collision
        int m_iX2,m_iY2; // coordonnes relatives aux coordonnes du sprite du coin bas droit du rectangle de collisionfloat m_fMasse; // en kg
        float m_fVx; // vitesse horizontale en pixels par seconde
        float m_fVy; // vitesse verticale en pixels par seconde
        float m_fVmaxX; // vitesse max verticale
        float m_fVmaxY; // vitesse max horizontale
        float m_fMasse; // masse en kg
        bool m_bBouge; // defini si l'entite bouge ou reste immobile
        bool m_bBloque[4]; // tableau qui indique les directions de blocage de l'entite
        bool m_bCollision; // defini si l'entite entre en collision avec d'autres
        ListeChainee<Force> *m_pListeForces;
        
    public:
        PhysicData(){}
        PhysicData(int iX, int iY, int iX1, int iY1, int iX2, int iY2, float fMasse, bool bBouge, bool bCollision);
        PhysicData(int iX, int iY, float fMasse, bool bBouge, bool bCollision);
        
        ~PhysicData();
        
        float getMasse(){ return m_fMasse;}
        float getVy(int iDirection);
        float getVx(int iDirection);
        float getFrot(int iDirection) { return m_fFrot[iDirection];}
        int getX1() { return m_iX1; }
        int getY1() { return m_iY1; }
        int getX2() { return m_iX2; }
        int getY2() { return m_iY2; }  
        float getX() { return m_fX; }
        float getY() { return m_fY; }
        float getVmaxY() { return m_fVmaxY;}
        float getVmaxX() { return m_fVmaxX;}
        bool arreteY() { return (m_fVy > -1 && m_fVy < 1) ;} 
        bool arreteX() { return (m_fVx > -1 && m_fVx < 1) ;} 
        bool bouge() { return !arreteY() || !arreteX();}
        bool arrete(int iDirection);
        bool getBouge() { return m_bBouge; }
        bool getCollision() { return m_bCollision; }
        bool getBloque( int iDirection ) { return m_bBloque[iDirection];}
        float getRebond( int iDirection )  { return m_fRebond[iDirection];}
        bool rebondi(int iDirection) { return m_fRebond[iDirection]>0.0 ; }
        bool getBloque() { return (m_bBloque[0] || m_bBloque[1] || m_bBloque[2] || m_bBloque[3]);}
        float getSommeForcesX(int iDirection);
        float getSommeForcesY(int iDirection);
                        
        void setMasse(float fMasse){ m_fMasse=fMasse;}
        void setVy(float fVy);
        void setVx(float fVx);
        void setVmaxY(float fVmaxY){ m_fVmaxY=fVmaxY;}
        void setVmaxX(float fVmaxX) { m_fVmaxX=fVmaxX;}
        void setCoordonnees(int iX1, int iY1, int iX2, int iY2) {m_iX1=iX1; m_iY1=iY1; m_iX2=iX2; m_iY2=iY2;}
        void setY(float fY){ m_fY=fY;}
        void setX(float fX) { m_fX=fX;}
        void setFrot(int iDirection , float fFrot) { m_fFrot[iDirection]=fFrot;}
        void setRebond(int iDirection, float fRebond) { m_fRebond[iDirection]=fRebond;}
        void setBouge( bool bBouge );
        void setCollision( bool bCollision ) { m_bCollision=bCollision; }
        void setBloque( int iDirection, bool bBloque ) { m_bBloque[iDirection]=bBloque;}           
                                       
        //interface avec la liste chaine
        void del(char *szNom){m_pListeForces->del( szNom );}
        Force * get( char * szNom ) { return m_pListeForces->get( szNom ); }
        int getSizeListe() { if (m_pListeForces!=NULL) return m_pListeForces->getSize(); else return 0; }
        Force *get(const int iRang) { return m_pListeForces->get(iRang) ; }
        void debut() { m_pListeForces->debut(); }
        bool suivant() { return m_pListeForces->suivant(); }
        Force * getCourant() { return m_pListeForces->getCourant() ; }

        void ajouterForce(Force *pForce, char *szNom);
        void ajouterGravite();
        void enleverForces();
        void debloquer();
};


#endif

